/*======================================================================
*
*  Immunix CryptoMark module
*  Copyright 1998, 1999, 2000 Wirex Communications &
* 			Oregon Graduate Institute
*
*	Greg Kroah-Hartman <greg@wirex.com>
*
*======================================================================*/

/* Module versioning code  */
#include <linux/autoconf.h> 		/* Retrieve the CONFIG_* macros */
#if defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
	#define MODVERSIONS 		/* Force it on */
	#include <linux/modversions.h>
#endif



/* __NO_VERSION__ is needed or else symbols get defined multiply */
//#define __NO_VERSION__
//#include <linux/version.h>
//#include <linux/module.h>

#include <asm/uaccess.h>
#include <linux/immunix.h>

#include "cryptomark.h"
#include "cryptomark_log.h"

/*======================================================================
*
* crypto_compute_elf_sig:
*  	Calls the immunix-md5 module to get a digital signature for 
*	elf executables.
*
*======================================================================*/
struct immunix_digital_sig * crypto_compute_elf_sig (struct elf_phdr *elf_phdata, int elf_e_phnum, char * name)
{
	dbg (__FUNCTION__ ": name = %s", name);
	return immunix_compute_elf_sig (elf_phdata, elf_e_phnum, name);
}


