/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * DRA7xx PRCM MPU instance offset macros
 *
 * Copyright (C) 2013 Texas Instruments Incorporated - http://www.ti.com
 *
 * Generated by code originally written by:
 * Paul Walmsley (paul@pwsan.com)
 * Rajendra Nayak (rnayak@ti.com)
 * Benoit Cousson (b-cousson@ti.com)
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 */

#ifndef __ARCH_ARM_MACH_OMAP2_PRCM_MPU7XX_H
#define __ARCH_ARM_MACH_OMAP2_PRCM_MPU7XX_H

#include "prcm_mpu_44xx_54xx.h"

#define DRA7XX_PRCM_MPU_BASE			0x48243000

#define DRA7XX_PRCM_MPU_REGADDR(inst, reg)				\
	OMAP2_L4_IO_ADDRESS(DRA7XX_PRCM_MPU_BASE + (inst) + (reg))

/* MPU_PRCM instances */
#define DRA7XX_MPU_PRCM_OCP_SOCKET_INST	0x0000
#define DRA7XX_MPU_PRCM_DEVICE_INST	0x0200
#define DRA7XX_MPU_PRCM_PRM_C0_INST	0x0400
#define DRA7XX_MPU_PRCM_CM_C0_INST	0x0600
#define DRA7XX_MPU_PRCM_PRM_C1_INST	0x0800
#define DRA7XX_MPU_PRCM_CM_C1_INST	0x0a00

/* PRCM_MPU clockdomain register offsets (from instance start) */
#define DRA7XX_MPU_PRCM_CM_C0_CPU0_CDOFFS	0x0000
#define DRA7XX_MPU_PRCM_CM_C1_CPU1_CDOFFS	0x0000


/* MPU_PRCM */

/* MPU_PRCM.PRCM_MPU_OCP_SOCKET register offsets */
#define DRA7XX_REVISION_PRCM_MPU_OFFSET				0x0000

/* MPU_PRCM.PRCM_MPU_DEVICE register offsets */
#define DRA7XX_PRM_FRAC_INCREMENTER_NUMERATOR_OFFSET		0x0010
#define DRA7XX_PRM_FRAC_INCREMENTER_DENUMERATOR_RELOAD_OFFSET	0x0014

/* MPU_PRCM.PRCM_MPU_PRM_C0 register offsets */
#define DRA7XX_PM_CPU0_PWRSTCTRL_OFFSET				0x0000
#define DRA7XX_PM_CPU0_PWRSTST_OFFSET				0x0004
#define DRA7XX_RM_CPU0_CPU0_RSTCTRL_OFFSET			0x0010
#define DRA7XX_RM_CPU0_CPU0_RSTST_OFFSET			0x0014
#define DRA7XX_RM_CPU0_CPU0_CONTEXT_OFFSET			0x0024

/* MPU_PRCM.PRCM_MPU_CM_C0 register offsets */
#define DRA7XX_CM_CPU0_CLKSTCTRL_OFFSET				0x0000
#define DRA7XX_CM_CPU0_CPU0_CLKCTRL_OFFSET			0x0020
#define DRA7XX_CM_CPU0_CPU0_CLKCTRL				DRA7XX_MPU_PRCM_REGADDR(DRA7XX_MPU_PRCM_CM_C0_INST, 0x0020)

/* MPU_PRCM.PRCM_MPU_PRM_C1 register offsets */
#define DRA7XX_PM_CPU1_PWRSTCTRL_OFFSET				0x0000
#define DRA7XX_PM_CPU1_PWRSTST_OFFSET				0x0004
#define DRA7XX_RM_CPU1_CPU1_RSTCTRL_OFFSET			0x0010
#define DRA7XX_RM_CPU1_CPU1_RSTST_OFFSET			0x0014
#define DRA7XX_RM_CPU1_CPU1_CONTEXT_OFFSET			0x0024

/* MPU_PRCM.PRCM_MPU_CM_C1 register offsets */
#define DRA7XX_CM_CPU1_CLKSTCTRL_OFFSET				0x0000
#define DRA7XX_CM_CPU1_CPU1_CLKCTRL_OFFSET			0x0020
#define DRA7XX_CM_CPU1_CPU1_CLKCTRL				DRA7XX_MPU_PRCM_REGADDR(DRA7XX_MPU_PRCM_CM_C1_INST, 0x0020)

#endif
