/* SPDX-License-Identifier: MIT */
/*
 * Copyright © 2023 Intel Corporation
 */

#ifndef __INTEL_VDSC_REGS_H__
#define __INTEL_VDSC_REGS_H__

#include "intel_display_reg_defs.h"

/* Display Stream Splitter Control */
#define DSS_CTL1				_MMIO(0x67400)
#define  SPLITTER_ENABLE			(1 << 31)
#define  JOINER_ENABLE				(1 << 30)
#define  DUAL_LINK_MODE_INTERLEAVE		(1 << 24)
#define  DUAL_LINK_MODE_FRONTBACK		(0 << 24)
#define  OVERLAP_PIXELS_MASK			(0xf << 16)
#define  OVERLAP_PIXELS(pixels)			((pixels) << 16)
#define  LEFT_DL_BUF_TARGET_DEPTH_MASK		(0xfff << 0)
#define  LEFT_DL_BUF_TARGET_DEPTH(pixels)	((pixels) << 0)
#define  MAX_DL_BUFFER_TARGET_DEPTH		0x5a0

#define DSS_CTL2				_MMIO(0x67404)
#define  LEFT_BRANCH_VDSC_ENABLE		(1 << 31)
#define  RIGHT_BRANCH_VDSC_ENABLE		(1 << 15)
#define  RIGHT_DL_BUF_TARGET_DEPTH_MASK		(0xfff << 0)
#define  RIGHT_DL_BUF_TARGET_DEPTH(pixels)	((pixels) << 0)

#define _ICL_PIPE_DSS_CTL1_PB			0x78200
#define _ICL_PIPE_DSS_CTL1_PC			0x78400
#define ICL_PIPE_DSS_CTL1(pipe)			_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_PIPE_DSS_CTL1_PB, \
							   _ICL_PIPE_DSS_CTL1_PC)
#define  BIG_JOINER_ENABLE			(1 << 29)
#define  MASTER_BIG_JOINER_ENABLE		(1 << 28)
#define  VGA_CENTERING_ENABLE			(1 << 27)
#define  SPLITTER_CONFIGURATION_MASK		REG_GENMASK(26, 25)
#define  SPLITTER_CONFIGURATION_2_SEGMENT	REG_FIELD_PREP(SPLITTER_CONFIGURATION_MASK, 0)
#define  SPLITTER_CONFIGURATION_4_SEGMENT	REG_FIELD_PREP(SPLITTER_CONFIGURATION_MASK, 1)
#define  UNCOMPRESSED_JOINER_MASTER		(1 << 21)
#define  UNCOMPRESSED_JOINER_SLAVE		(1 << 20)

#define _ICL_PIPE_DSS_CTL2_PB			0x78204
#define _ICL_PIPE_DSS_CTL2_PC			0x78404
#define ICL_PIPE_DSS_CTL2(pipe)			_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_PIPE_DSS_CTL2_PB, \
							   _ICL_PIPE_DSS_CTL2_PC)

/* MTL Display Stream Compression registers */
#define _MTL_DSC0_PICTURE_PARAMETER_SET_17_PB	0x782B4
#define _MTL_DSC1_PICTURE_PARAMETER_SET_17_PB	0x783B4
#define _MTL_DSC0_PICTURE_PARAMETER_SET_17_PC	0x784B4
#define _MTL_DSC1_PICTURE_PARAMETER_SET_17_PC	0x785B4
#define MTL_DSC0_PICTURE_PARAMETER_SET_17(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _MTL_DSC0_PICTURE_PARAMETER_SET_17_PB, \
							   _MTL_DSC0_PICTURE_PARAMETER_SET_17_PC)
#define MTL_DSC1_PICTURE_PARAMETER_SET_17(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _MTL_DSC1_PICTURE_PARAMETER_SET_17_PB, \
							   _MTL_DSC1_PICTURE_PARAMETER_SET_17_PC)
#define DSC_SL_BPG_OFFSET(offset)		((offset) << 27)

#define _MTL_DSC0_PICTURE_PARAMETER_SET_18_PB	0x782B8
#define _MTL_DSC1_PICTURE_PARAMETER_SET_18_PB	0x783B8
#define _MTL_DSC0_PICTURE_PARAMETER_SET_18_PC	0x784B8
#define _MTL_DSC1_PICTURE_PARAMETER_SET_18_PC	0x785B8
#define MTL_DSC0_PICTURE_PARAMETER_SET_18(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _MTL_DSC0_PICTURE_PARAMETER_SET_18_PB, \
							   _MTL_DSC0_PICTURE_PARAMETER_SET_18_PC)
#define MTL_DSC1_PICTURE_PARAMETER_SET_18(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _MTL_DSC1_PICTURE_PARAMETER_SET_18_PB, \
							   _MTL_DSC1_PICTURE_PARAMETER_SET_18_PC)
#define DSC_NSL_BPG_OFFSET(offset)		((offset) << 16)
#define DSC_SL_OFFSET_ADJ(offset)		((offset) << 0)

/* Icelake Display Stream Compression Registers */
#define DSCA_PICTURE_PARAMETER_SET_0		_MMIO(0x6B200)
#define DSCC_PICTURE_PARAMETER_SET_0		_MMIO(0x6BA00)
#define _ICL_DSC0_PICTURE_PARAMETER_SET_0_PB	0x78270
#define _ICL_DSC1_PICTURE_PARAMETER_SET_0_PB	0x78370
#define _ICL_DSC0_PICTURE_PARAMETER_SET_0_PC	0x78470
#define _ICL_DSC1_PICTURE_PARAMETER_SET_0_PC	0x78570
#define ICL_DSC0_PICTURE_PARAMETER_SET_0(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_0_PB, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_0_PC)
#define ICL_DSC1_PICTURE_PARAMETER_SET_0(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_0_PB, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_0_PC)
#define  DSC_NATIVE_422_ENABLE		BIT(23)
#define  DSC_NATIVE_420_ENABLE		BIT(22)
#define  DSC_ALT_ICH_SEL		(1 << 20)
#define  DSC_VBR_ENABLE			(1 << 19)
#define  DSC_422_ENABLE			(1 << 18)
#define  DSC_COLOR_SPACE_CONVERSION	(1 << 17)
#define  DSC_BLOCK_PREDICTION		(1 << 16)
#define  DSC_LINE_BUF_DEPTH_SHIFT	12
#define  DSC_BPC_SHIFT			8
#define  DSC_VER_MIN_SHIFT		4
#define  DSC_VER_MAJ			(0x1 << 0)

#define DSCA_PICTURE_PARAMETER_SET_1		_MMIO(0x6B204)
#define DSCC_PICTURE_PARAMETER_SET_1		_MMIO(0x6BA04)
#define _ICL_DSC0_PICTURE_PARAMETER_SET_1_PB	0x78274
#define _ICL_DSC1_PICTURE_PARAMETER_SET_1_PB	0x78374
#define _ICL_DSC0_PICTURE_PARAMETER_SET_1_PC	0x78474
#define _ICL_DSC1_PICTURE_PARAMETER_SET_1_PC	0x78574
#define ICL_DSC0_PICTURE_PARAMETER_SET_1(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_1_PB, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_1_PC)
#define ICL_DSC1_PICTURE_PARAMETER_SET_1(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_1_PB, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_1_PC)
#define  DSC_BPP(bpp)				((bpp) << 0)

#define DSCA_PICTURE_PARAMETER_SET_2		_MMIO(0x6B208)
#define DSCC_PICTURE_PARAMETER_SET_2		_MMIO(0x6BA08)
#define _ICL_DSC0_PICTURE_PARAMETER_SET_2_PB	0x78278
#define _ICL_DSC1_PICTURE_PARAMETER_SET_2_PB	0x78378
#define _ICL_DSC0_PICTURE_PARAMETER_SET_2_PC	0x78478
#define _ICL_DSC1_PICTURE_PARAMETER_SET_2_PC	0x78578
#define ICL_DSC0_PICTURE_PARAMETER_SET_2(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_2_PB, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_2_PC)
#define ICL_DSC1_PICTURE_PARAMETER_SET_2(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
					    _ICL_DSC1_PICTURE_PARAMETER_SET_2_PB, \
					    _ICL_DSC1_PICTURE_PARAMETER_SET_2_PC)
#define  DSC_PIC_WIDTH(pic_width)	((pic_width) << 16)
#define  DSC_PIC_HEIGHT(pic_height)	((pic_height) << 0)

#define DSCA_PICTURE_PARAMETER_SET_3		_MMIO(0x6B20C)
#define DSCC_PICTURE_PARAMETER_SET_3		_MMIO(0x6BA0C)
#define _ICL_DSC0_PICTURE_PARAMETER_SET_3_PB	0x7827C
#define _ICL_DSC1_PICTURE_PARAMETER_SET_3_PB	0x7837C
#define _ICL_DSC0_PICTURE_PARAMETER_SET_3_PC	0x7847C
#define _ICL_DSC1_PICTURE_PARAMETER_SET_3_PC	0x7857C
#define ICL_DSC0_PICTURE_PARAMETER_SET_3(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_3_PB, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_3_PC)
#define ICL_DSC1_PICTURE_PARAMETER_SET_3(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_3_PB, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_3_PC)
#define  DSC_SLICE_WIDTH(slice_width)   ((slice_width) << 16)
#define  DSC_SLICE_HEIGHT(slice_height) ((slice_height) << 0)

#define DSCA_PICTURE_PARAMETER_SET_4		_MMIO(0x6B210)
#define DSCC_PICTURE_PARAMETER_SET_4		_MMIO(0x6BA10)
#define _ICL_DSC0_PICTURE_PARAMETER_SET_4_PB	0x78280
#define _ICL_DSC1_PICTURE_PARAMETER_SET_4_PB	0x78380
#define _ICL_DSC0_PICTURE_PARAMETER_SET_4_PC	0x78480
#define _ICL_DSC1_PICTURE_PARAMETER_SET_4_PC	0x78580
#define ICL_DSC0_PICTURE_PARAMETER_SET_4(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_4_PB, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_4_PC)
#define ICL_DSC1_PICTURE_PARAMETER_SET_4(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_4_PB, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_4_PC)
#define  DSC_INITIAL_DEC_DELAY(dec_delay)       ((dec_delay) << 16)
#define  DSC_INITIAL_XMIT_DELAY(xmit_delay)     ((xmit_delay) << 0)

#define DSCA_PICTURE_PARAMETER_SET_5		_MMIO(0x6B214)
#define DSCC_PICTURE_PARAMETER_SET_5		_MMIO(0x6BA14)
#define _ICL_DSC0_PICTURE_PARAMETER_SET_5_PB	0x78284
#define _ICL_DSC1_PICTURE_PARAMETER_SET_5_PB	0x78384
#define _ICL_DSC0_PICTURE_PARAMETER_SET_5_PC	0x78484
#define _ICL_DSC1_PICTURE_PARAMETER_SET_5_PC	0x78584
#define ICL_DSC0_PICTURE_PARAMETER_SET_5(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_5_PB, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_5_PC)
#define ICL_DSC1_PICTURE_PARAMETER_SET_5(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_5_PB, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_5_PC)
#define  DSC_SCALE_DEC_INT(scale_dec)	((scale_dec) << 16)
#define  DSC_SCALE_INC_INT(scale_inc)		((scale_inc) << 0)

#define DSCA_PICTURE_PARAMETER_SET_6		_MMIO(0x6B218)
#define DSCC_PICTURE_PARAMETER_SET_6		_MMIO(0x6BA18)
#define _ICL_DSC0_PICTURE_PARAMETER_SET_6_PB	0x78288
#define _ICL_DSC1_PICTURE_PARAMETER_SET_6_PB	0x78388
#define _ICL_DSC0_PICTURE_PARAMETER_SET_6_PC	0x78488
#define _ICL_DSC1_PICTURE_PARAMETER_SET_6_PC	0x78588
#define ICL_DSC0_PICTURE_PARAMETER_SET_6(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_6_PB, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_6_PC)
#define ICL_DSC1_PICTURE_PARAMETER_SET_6(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_6_PB, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_6_PC)
#define  DSC_FLATNESS_MAX_QP(max_qp)		((max_qp) << 24)
#define  DSC_FLATNESS_MIN_QP(min_qp)		((min_qp) << 16)
#define  DSC_FIRST_LINE_BPG_OFFSET(offset)	((offset) << 8)
#define  DSC_INITIAL_SCALE_VALUE(value)		((value) << 0)

#define DSCA_PICTURE_PARAMETER_SET_7		_MMIO(0x6B21C)
#define DSCC_PICTURE_PARAMETER_SET_7		_MMIO(0x6BA1C)
#define _ICL_DSC0_PICTURE_PARAMETER_SET_7_PB	0x7828C
#define _ICL_DSC1_PICTURE_PARAMETER_SET_7_PB	0x7838C
#define _ICL_DSC0_PICTURE_PARAMETER_SET_7_PC	0x7848C
#define _ICL_DSC1_PICTURE_PARAMETER_SET_7_PC	0x7858C
#define ICL_DSC0_PICTURE_PARAMETER_SET_7(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							    _ICL_DSC0_PICTURE_PARAMETER_SET_7_PB, \
							    _ICL_DSC0_PICTURE_PARAMETER_SET_7_PC)
#define ICL_DSC1_PICTURE_PARAMETER_SET_7(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							    _ICL_DSC1_PICTURE_PARAMETER_SET_7_PB, \
							    _ICL_DSC1_PICTURE_PARAMETER_SET_7_PC)
#define  DSC_NFL_BPG_OFFSET(bpg_offset)		((bpg_offset) << 16)
#define  DSC_SLICE_BPG_OFFSET(bpg_offset)	((bpg_offset) << 0)

#define DSCA_PICTURE_PARAMETER_SET_8		_MMIO(0x6B220)
#define DSCC_PICTURE_PARAMETER_SET_8		_MMIO(0x6BA20)
#define _ICL_DSC0_PICTURE_PARAMETER_SET_8_PB	0x78290
#define _ICL_DSC1_PICTURE_PARAMETER_SET_8_PB	0x78390
#define _ICL_DSC0_PICTURE_PARAMETER_SET_8_PC	0x78490
#define _ICL_DSC1_PICTURE_PARAMETER_SET_8_PC	0x78590
#define ICL_DSC0_PICTURE_PARAMETER_SET_8(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_8_PB, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_8_PC)
#define ICL_DSC1_PICTURE_PARAMETER_SET_8(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_8_PB, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_8_PC)
#define  DSC_INITIAL_OFFSET(initial_offset)		((initial_offset) << 16)
#define  DSC_FINAL_OFFSET(final_offset)			((final_offset) << 0)

#define DSCA_PICTURE_PARAMETER_SET_9		_MMIO(0x6B224)
#define DSCC_PICTURE_PARAMETER_SET_9		_MMIO(0x6BA24)
#define _ICL_DSC0_PICTURE_PARAMETER_SET_9_PB	0x78294
#define _ICL_DSC1_PICTURE_PARAMETER_SET_9_PB	0x78394
#define _ICL_DSC0_PICTURE_PARAMETER_SET_9_PC	0x78494
#define _ICL_DSC1_PICTURE_PARAMETER_SET_9_PC	0x78594
#define ICL_DSC0_PICTURE_PARAMETER_SET_9(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_9_PB, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_9_PC)
#define ICL_DSC1_PICTURE_PARAMETER_SET_9(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_9_PB, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_9_PC)
#define  DSC_RC_EDGE_FACTOR(rc_edge_fact)	((rc_edge_fact) << 16)
#define  DSC_RC_MODEL_SIZE(rc_model_size)	((rc_model_size) << 0)

#define DSCA_PICTURE_PARAMETER_SET_10		_MMIO(0x6B228)
#define DSCC_PICTURE_PARAMETER_SET_10		_MMIO(0x6BA28)
#define _ICL_DSC0_PICTURE_PARAMETER_SET_10_PB	0x78298
#define _ICL_DSC1_PICTURE_PARAMETER_SET_10_PB	0x78398
#define _ICL_DSC0_PICTURE_PARAMETER_SET_10_PC	0x78498
#define _ICL_DSC1_PICTURE_PARAMETER_SET_10_PC	0x78598
#define ICL_DSC0_PICTURE_PARAMETER_SET_10(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_10_PB, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_10_PC)
#define ICL_DSC1_PICTURE_PARAMETER_SET_10(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_10_PB, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_10_PC)
#define  DSC_RC_TARGET_OFF_LOW(rc_tgt_off_low)		((rc_tgt_off_low) << 20)
#define  DSC_RC_TARGET_OFF_HIGH(rc_tgt_off_high)	((rc_tgt_off_high) << 16)
#define  DSC_RC_QUANT_INC_LIMIT1(lim)			((lim) << 8)
#define  DSC_RC_QUANT_INC_LIMIT0(lim)			((lim) << 0)

#define DSCA_PICTURE_PARAMETER_SET_11		_MMIO(0x6B22C)
#define DSCC_PICTURE_PARAMETER_SET_11		_MMIO(0x6BA2C)
#define _ICL_DSC0_PICTURE_PARAMETER_SET_11_PB	0x7829C
#define _ICL_DSC1_PICTURE_PARAMETER_SET_11_PB	0x7839C
#define _ICL_DSC0_PICTURE_PARAMETER_SET_11_PC	0x7849C
#define _ICL_DSC1_PICTURE_PARAMETER_SET_11_PC	0x7859C
#define ICL_DSC0_PICTURE_PARAMETER_SET_11(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_11_PB, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_11_PC)
#define ICL_DSC1_PICTURE_PARAMETER_SET_11(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_11_PB, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_11_PC)

#define DSCA_PICTURE_PARAMETER_SET_12		_MMIO(0x6B260)
#define DSCC_PICTURE_PARAMETER_SET_12		_MMIO(0x6BA60)
#define _ICL_DSC0_PICTURE_PARAMETER_SET_12_PB	0x782A0
#define _ICL_DSC1_PICTURE_PARAMETER_SET_12_PB	0x783A0
#define _ICL_DSC0_PICTURE_PARAMETER_SET_12_PC	0x784A0
#define _ICL_DSC1_PICTURE_PARAMETER_SET_12_PC	0x785A0
#define ICL_DSC0_PICTURE_PARAMETER_SET_12(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_12_PB, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_12_PC)
#define ICL_DSC1_PICTURE_PARAMETER_SET_12(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_12_PB, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_12_PC)

#define DSCA_PICTURE_PARAMETER_SET_13		_MMIO(0x6B264)
#define DSCC_PICTURE_PARAMETER_SET_13		_MMIO(0x6BA64)
#define _ICL_DSC0_PICTURE_PARAMETER_SET_13_PB	0x782A4
#define _ICL_DSC1_PICTURE_PARAMETER_SET_13_PB	0x783A4
#define _ICL_DSC0_PICTURE_PARAMETER_SET_13_PC	0x784A4
#define _ICL_DSC1_PICTURE_PARAMETER_SET_13_PC	0x785A4
#define ICL_DSC0_PICTURE_PARAMETER_SET_13(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_13_PB, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_13_PC)
#define ICL_DSC1_PICTURE_PARAMETER_SET_13(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_13_PB, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_13_PC)

#define DSCA_PICTURE_PARAMETER_SET_14		_MMIO(0x6B268)
#define DSCC_PICTURE_PARAMETER_SET_14		_MMIO(0x6BA68)
#define _ICL_DSC0_PICTURE_PARAMETER_SET_14_PB	0x782A8
#define _ICL_DSC1_PICTURE_PARAMETER_SET_14_PB	0x783A8
#define _ICL_DSC0_PICTURE_PARAMETER_SET_14_PC	0x784A8
#define _ICL_DSC1_PICTURE_PARAMETER_SET_14_PC	0x785A8
#define ICL_DSC0_PICTURE_PARAMETER_SET_14(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_14_PB, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_14_PC)
#define ICL_DSC1_PICTURE_PARAMETER_SET_14(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_14_PB, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_14_PC)

#define DSCA_PICTURE_PARAMETER_SET_15		_MMIO(0x6B26C)
#define DSCC_PICTURE_PARAMETER_SET_15		_MMIO(0x6BA6C)
#define _ICL_DSC0_PICTURE_PARAMETER_SET_15_PB	0x782AC
#define _ICL_DSC1_PICTURE_PARAMETER_SET_15_PB	0x783AC
#define _ICL_DSC0_PICTURE_PARAMETER_SET_15_PC	0x784AC
#define _ICL_DSC1_PICTURE_PARAMETER_SET_15_PC	0x785AC
#define ICL_DSC0_PICTURE_PARAMETER_SET_15(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_15_PB, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_15_PC)
#define ICL_DSC1_PICTURE_PARAMETER_SET_15(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_15_PB, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_15_PC)

#define DSCA_PICTURE_PARAMETER_SET_16		_MMIO(0x6B270)
#define DSCC_PICTURE_PARAMETER_SET_16		_MMIO(0x6BA70)
#define _ICL_DSC0_PICTURE_PARAMETER_SET_16_PB	0x782B0
#define _ICL_DSC1_PICTURE_PARAMETER_SET_16_PB	0x783B0
#define _ICL_DSC0_PICTURE_PARAMETER_SET_16_PC	0x784B0
#define _ICL_DSC1_PICTURE_PARAMETER_SET_16_PC	0x785B0
#define ICL_DSC0_PICTURE_PARAMETER_SET_16(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_16_PB, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_16_PC)
#define ICL_DSC1_PICTURE_PARAMETER_SET_16(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_16_PB, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_16_PC)
#define  DSC_SLICE_ROW_PER_FRAME(slice_row_per_frame)	((slice_row_per_frame) << 20)
#define  DSC_SLICE_PER_LINE(slice_per_line)		((slice_per_line) << 16)
#define  DSC_SLICE_CHUNK_SIZE(slice_chunk_size)		((slice_chunk_size) << 0)

/* Icelake Rate Control Buffer Threshold Registers */
#define DSCA_RC_BUF_THRESH_0			_MMIO(0x6B230)
#define DSCA_RC_BUF_THRESH_0_UDW		_MMIO(0x6B230 + 4)
#define DSCC_RC_BUF_THRESH_0			_MMIO(0x6BA30)
#define DSCC_RC_BUF_THRESH_0_UDW		_MMIO(0x6BA30 + 4)
#define _ICL_DSC0_RC_BUF_THRESH_0_PB		(0x78254)
#define _ICL_DSC0_RC_BUF_THRESH_0_UDW_PB	(0x78254 + 4)
#define _ICL_DSC1_RC_BUF_THRESH_0_PB		(0x78354)
#define _ICL_DSC1_RC_BUF_THRESH_0_UDW_PB	(0x78354 + 4)
#define _ICL_DSC0_RC_BUF_THRESH_0_PC		(0x78454)
#define _ICL_DSC0_RC_BUF_THRESH_0_UDW_PC	(0x78454 + 4)
#define _ICL_DSC1_RC_BUF_THRESH_0_PC		(0x78554)
#define _ICL_DSC1_RC_BUF_THRESH_0_UDW_PC	(0x78554 + 4)
#define ICL_DSC0_RC_BUF_THRESH_0(pipe)		_MMIO_PIPE((pipe) - PIPE_B, \
						_ICL_DSC0_RC_BUF_THRESH_0_PB, \
						_ICL_DSC0_RC_BUF_THRESH_0_PC)
#define ICL_DSC0_RC_BUF_THRESH_0_UDW(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
						_ICL_DSC0_RC_BUF_THRESH_0_UDW_PB, \
						_ICL_DSC0_RC_BUF_THRESH_0_UDW_PC)
#define ICL_DSC1_RC_BUF_THRESH_0(pipe)		_MMIO_PIPE((pipe) - PIPE_B, \
						_ICL_DSC1_RC_BUF_THRESH_0_PB, \
						_ICL_DSC1_RC_BUF_THRESH_0_PC)
#define ICL_DSC1_RC_BUF_THRESH_0_UDW(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
						_ICL_DSC1_RC_BUF_THRESH_0_UDW_PB, \
						_ICL_DSC1_RC_BUF_THRESH_0_UDW_PC)

#define DSCA_RC_BUF_THRESH_1			_MMIO(0x6B238)
#define DSCA_RC_BUF_THRESH_1_UDW		_MMIO(0x6B238 + 4)
#define DSCC_RC_BUF_THRESH_1			_MMIO(0x6BA38)
#define DSCC_RC_BUF_THRESH_1_UDW		_MMIO(0x6BA38 + 4)
#define _ICL_DSC0_RC_BUF_THRESH_1_PB		(0x7825C)
#define _ICL_DSC0_RC_BUF_THRESH_1_UDW_PB	(0x7825C + 4)
#define _ICL_DSC1_RC_BUF_THRESH_1_PB		(0x7835C)
#define _ICL_DSC1_RC_BUF_THRESH_1_UDW_PB	(0x7835C + 4)
#define _ICL_DSC0_RC_BUF_THRESH_1_PC		(0x7845C)
#define _ICL_DSC0_RC_BUF_THRESH_1_UDW_PC	(0x7845C + 4)
#define _ICL_DSC1_RC_BUF_THRESH_1_PC		(0x7855C)
#define _ICL_DSC1_RC_BUF_THRESH_1_UDW_PC	(0x7855C + 4)
#define ICL_DSC0_RC_BUF_THRESH_1(pipe)		_MMIO_PIPE((pipe) - PIPE_B, \
						_ICL_DSC0_RC_BUF_THRESH_1_PB, \
						_ICL_DSC0_RC_BUF_THRESH_1_PC)
#define ICL_DSC0_RC_BUF_THRESH_1_UDW(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
						_ICL_DSC0_RC_BUF_THRESH_1_UDW_PB, \
						_ICL_DSC0_RC_BUF_THRESH_1_UDW_PC)
#define ICL_DSC1_RC_BUF_THRESH_1(pipe)		_MMIO_PIPE((pipe) - PIPE_B, \
						_ICL_DSC1_RC_BUF_THRESH_1_PB, \
						_ICL_DSC1_RC_BUF_THRESH_1_PC)
#define ICL_DSC1_RC_BUF_THRESH_1_UDW(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
						_ICL_DSC1_RC_BUF_THRESH_1_UDW_PB, \
						_ICL_DSC1_RC_BUF_THRESH_1_UDW_PC)

/* Icelake DSC Rate Control Range Parameter Registers */
#define DSCA_RC_RANGE_PARAMETERS_0		_MMIO(0x6B240)
#define DSCA_RC_RANGE_PARAMETERS_0_UDW		_MMIO(0x6B240 + 4)
#define DSCC_RC_RANGE_PARAMETERS_0		_MMIO(0x6BA40)
#define DSCC_RC_RANGE_PARAMETERS_0_UDW		_MMIO(0x6BA40 + 4)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_0_PB	(0x78208)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_0_UDW_PB	(0x78208 + 4)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_0_PB	(0x78308)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_0_UDW_PB	(0x78308 + 4)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_0_PC	(0x78408)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_0_UDW_PC	(0x78408 + 4)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_0_PC	(0x78508)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_0_UDW_PC	(0x78508 + 4)
#define ICL_DSC0_RC_RANGE_PARAMETERS_0(pipe)		_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_0_PB, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_0_PC)
#define ICL_DSC0_RC_RANGE_PARAMETERS_0_UDW(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_0_UDW_PB, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_0_UDW_PC)
#define ICL_DSC1_RC_RANGE_PARAMETERS_0(pipe)		_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_0_PB, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_0_PC)
#define ICL_DSC1_RC_RANGE_PARAMETERS_0_UDW(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_0_UDW_PB, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_0_UDW_PC)
#define RC_BPG_OFFSET_SHIFT			10
#define RC_MAX_QP_SHIFT				5
#define RC_MIN_QP_SHIFT				0

#define DSCA_RC_RANGE_PARAMETERS_1		_MMIO(0x6B248)
#define DSCA_RC_RANGE_PARAMETERS_1_UDW		_MMIO(0x6B248 + 4)
#define DSCC_RC_RANGE_PARAMETERS_1		_MMIO(0x6BA48)
#define DSCC_RC_RANGE_PARAMETERS_1_UDW		_MMIO(0x6BA48 + 4)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_1_PB	(0x78210)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_1_UDW_PB	(0x78210 + 4)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_1_PB	(0x78310)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_1_UDW_PB	(0x78310 + 4)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_1_PC	(0x78410)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_1_UDW_PC	(0x78410 + 4)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_1_PC	(0x78510)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_1_UDW_PC	(0x78510 + 4)
#define ICL_DSC0_RC_RANGE_PARAMETERS_1(pipe)		_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_1_PB, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_1_PC)
#define ICL_DSC0_RC_RANGE_PARAMETERS_1_UDW(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_1_UDW_PB, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_1_UDW_PC)
#define ICL_DSC1_RC_RANGE_PARAMETERS_1(pipe)		_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_1_PB, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_1_PC)
#define ICL_DSC1_RC_RANGE_PARAMETERS_1_UDW(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_1_UDW_PB, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_1_UDW_PC)

#define DSCA_RC_RANGE_PARAMETERS_2		_MMIO(0x6B250)
#define DSCA_RC_RANGE_PARAMETERS_2_UDW		_MMIO(0x6B250 + 4)
#define DSCC_RC_RANGE_PARAMETERS_2		_MMIO(0x6BA50)
#define DSCC_RC_RANGE_PARAMETERS_2_UDW		_MMIO(0x6BA50 + 4)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_2_PB	(0x78218)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_2_UDW_PB	(0x78218 + 4)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_2_PB	(0x78318)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_2_UDW_PB	(0x78318 + 4)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_2_PC	(0x78418)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_2_UDW_PC	(0x78418 + 4)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_2_PC	(0x78518)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_2_UDW_PC	(0x78518 + 4)
#define ICL_DSC0_RC_RANGE_PARAMETERS_2(pipe)		_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_2_PB, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_2_PC)
#define ICL_DSC0_RC_RANGE_PARAMETERS_2_UDW(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_2_UDW_PB, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_2_UDW_PC)
#define ICL_DSC1_RC_RANGE_PARAMETERS_2(pipe)		_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_2_PB, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_2_PC)
#define ICL_DSC1_RC_RANGE_PARAMETERS_2_UDW(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_2_UDW_PB, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_2_UDW_PC)

#define DSCA_RC_RANGE_PARAMETERS_3		_MMIO(0x6B258)
#define DSCA_RC_RANGE_PARAMETERS_3_UDW		_MMIO(0x6B258 + 4)
#define DSCC_RC_RANGE_PARAMETERS_3		_MMIO(0x6BA58)
#define DSCC_RC_RANGE_PARAMETERS_3_UDW		_MMIO(0x6BA58 + 4)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_3_PB	(0x78220)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_3_UDW_PB	(0x78220 + 4)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_3_PB	(0x78320)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_3_UDW_PB	(0x78320 + 4)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_3_PC	(0x78420)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_3_UDW_PC	(0x78420 + 4)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_3_PC	(0x78520)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_3_UDW_PC	(0x78520 + 4)
#define ICL_DSC0_RC_RANGE_PARAMETERS_3(pipe)		_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_3_PB, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_3_PC)
#define ICL_DSC0_RC_RANGE_PARAMETERS_3_UDW(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_3_UDW_PB, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_3_UDW_PC)
#define ICL_DSC1_RC_RANGE_PARAMETERS_3(pipe)		_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_3_PB, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_3_PC)
#define ICL_DSC1_RC_RANGE_PARAMETERS_3_UDW(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_3_UDW_PB, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_3_UDW_PC)

#endif /* __INTEL_VDSC_REGS_H__ */
