/*
   ** Copyright 1996 Thorsten Kukuk <kukuk@uni-paderborn.de>
   **
   ** This program is free software; you can redistribute it and/or modify
   ** it under the terms of the GNU General Public License as published by
   ** the Free Software Foundation; either version 2 of the License, or
   ** (at your option) any later version.
   **
   ** This program is distributed in the hope that it will be useful,
   ** but WITHOUT ANY WARRANTY; without even the implied warranty of
   ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   ** GNU General Public License for more details.
   **
   ** You should have received a copy of the GNU General Public License
   ** along with this program; if not, write to the Free Software
   ** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __PWDUTILS_H__
#define __PWDUTILS_H__

#include <pwd.h>
#include <sys/types.h>

#define PWD_TEMP "/etc/passwd.tmp"
#define PWD_PATH "/etc/passwd"
#define VI_PATH "/usr/bin/vi"

struct npwd
  {
    char *shell;
    char *username;
    char *old_username;
    char *full_name;
    char *old_full_name;
    char *office;
    char *old_office;
    char *office_phone;
    char *old_office_phone;
    char *home_phone;
    char *old_home_phone;
    char *other;
  };

extern char *progname;

extern int check_shell (char *);
extern void print_shell_list ();
extern void parse_passwd (struct passwd *, struct npwd *);
extern void pwd_init (void);
extern void pwd_error (const char *, const char *);
extern void *xmalloc (int bytes);
extern char *prompt (char *question, char *def_val);

extern char *get_master_server (void);
extern char *getoldpwd (struct passwd *);
extern char *getnewpwd (struct passwd *);
extern int verifypassword (struct passwd *, char *, uid_t);
extern int yp_writeback (struct passwd *, char *, char *);
extern int set_changed_finger_data (struct passwd *, struct npwd *);
extern char *FascistCheck (char *pw, char *dictpath);

#endif
