#ifndef _LINUX_JFS_CHECK_H
#define _LINUX_JFS_CHECK_H

#include <linux/autoconf.h>

#if defined(CONFIG_EXT3_FS_JFS_CHECK) && (defined(CONFIG_EXT3_FS) || defined(CONFIG_EXT3_FS_MODULE))
struct buffer_head;
extern void real_jfs_preclean_buffer_check(struct buffer_head *);
extern void real_jfs_prelock_buffer_check(struct buffer_head *);
extern void (*jfs_preclean_buffer_check)(struct buffer_head *);
extern void (*jfs_prelock_buffer_check)(struct buffer_head *);
#define call_jfs_preclean_buffer_check(bh) (*jfs_preclean_buffer_check) (bh)
#define call_jfs_prelock_buffer_check(bh) (*jfs_prelock_buffer_check) (bh)
#else 
#define call_jfs_preclean_buffer_check(bh)	do {} while (0)
#define call_jfs_prelock_buffer_check(bh)	do {} while (0)
#endif

#endif /* _LINUX_JFS_CHECK_H */
